<style>
    .switch {
      position: relative;
      display: inline-block;
      width: 60px;
      height: 34px;
    }
    
    .switch input { 
      opacity: 0;
      width: 0;
      height: 0;
    }
    
    .slider {
      position: absolute;
      cursor: pointer;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background-color: #ccc;
      -webkit-transition: .4s;
      transition: .4s;
    }
    
    .slider:before {
      position: absolute;
      content: "";
      height: 26px;
      width: 26px;
      left: 4px;
      bottom: 4px;
      background-color: white;
      -webkit-transition: .4s;
      transition: .4s;
    }
    
    input:checked + .slider {
      background-color: #2196F3;
    }
    
    input:focus + .slider {
      box-shadow: 0 0 1px #2196F3;
    }
    
    input:checked + .slider:before {
      -webkit-transform: translateX(26px);
      -ms-transform: translateX(26px);
      transform: translateX(26px);
    }
    
    /* Rounded sliders */
    .slider.round {
      border-radius: 34px;
    }
    
    .slider.round:before {
      border-radius: 50%;
    }


    .setfullwhi{
        width: 84vw;
        border-radius: 15px;
     
    }


    .grid-menu {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 15px;
        padding: 0;
        list-style: none;
    }

    .grid-menu .nav-item {
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .grid-menu .nav-link {
        text-align: center;
        width: 100%;
    }

    @media (max-width: 576px) {
        .grid-menu {
            grid-template-columns: repeat(2, 1fr);
        }
    }

</style>
    
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>



<x-header>
  <main class="main-content w-full px-[var(--margin-x)] pb-8">
    <div class="mt-4 grid grid-cols-1 gap-6 sm:mt-5 lg:mt-6">

      <div class="col-span-12 lg:col-span-8">
     



        <!-- Card -->
        <div
          class="relative overflow-hidden rounded-2xl border border-white/20 bg-gradient-to-br from-emerald-50/70 via-white/70 to-emerald-100/70 shadow-xl backdrop-blur-xl transition-all duration-700 hover:shadow-2xl hover:scale-[1.01] dark:from-[#0f172a]/70 dark:via-[#1e293b]/70 dark:to-[#0f172a]/70 animate-fadeInUp"
        >
          <div class="absolute inset-0 rounded-2xl bg-gradient-to-r from-emerald-400/10 via-transparent to-emerald-400/10 animate-borderGlow"></div>

          <!-- Header -->
          <div class="flex flex-col items-center justify-between space-y-4 border-b border-white/20 p-4 sm:flex-row sm:space-y-0 sm:p-5">
            <h2 class="text-xl font-semibold tracking-wide text-slate-800 dark:text-white flex items-center gap-2">
              <i class="fa-solid fa-image text-emerald-500"></i> Add Wallpaper Category
            </h2>

            <div class="flex justify-center space-x-2">
              <a href="{{ url('/admin/dashboard') }}"
                class="btn min-w-[7rem] rounded-full border border-slate-300 font-medium text-slate-700 hover:bg-slate-100 focus:bg-slate-100 active:bg-slate-200 transition-all dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-600">
                Cancel
              </a>

              <!-- Gradient Upload Button -->
              <button
                class="relative overflow-hidden btn min-w-[7rem] rounded-full font-semibold text-white shadow-md transition-all duration-500 hover:shadow-xl active:scale-95 focus:outline-none"
                form="myform"
                type="submit"

                style="background-color: green;"     
              >
                <span class="absolute inset-0 bg-gradient-to-r from-emerald-500 via-teal-500 to-green-500 bg-[length:200%_200%] animate-gradientFlow"></span>
                <span class="relative flex items-center justify-center gap-1">
                  <i class="fa-solid fa-cloud-arrow-up text-white"></i>
                  Upload
                </span>
              </button>
            </div>
          </div>

          <!-- Form -->
          <div class="p-5">
            <form method="POST" action="" id="myform" enctype="multipart/form-data">
              @csrf

              <!-- Image Upload -->
              <div class="flex flex-col items-center space-y-2">
                <div
                  class="relative avatar h-28 w-28 overflow-hidden rounded-full border-4 border-white/50 shadow-inner transition-all duration-500 hover:scale-105 hover:border-emerald-400/80 bg-white/60 backdrop-blur-md"
                >
                  <img id="img-preview" class="object-cover w-full h-full" src="../images/upload.png" alt="avatar">
                  <div class="absolute bottom-1 right-1 flex items-center justify-center rounded-full bg-white/80 shadow-md p-1 dark:bg-navy-700/90">
                    <label
                      class="btn h-6 w-6 rounded-full border border-slate-300 p-0 bg-slate-50 hover:bg-slate-200 dark:border-navy-500 dark:bg-navy-600 dark:hover:bg-navy-500 transition-all cursor-pointer"
                    >
                      <input id="choose-file" tabindex="-1" type="file" name="image"
                        class="absolute inset-0 h-full w-full opacity-0" required />
                      <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5 text-emerald-600" viewBox="0 0 20 20"
                        fill="currentColor">
                        <path
                          d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z">
                        </path>
                      </svg>
                    </label>
                  </div>
                </div>
                <p class="text-xs text-slate-500 dark:text-navy-200">Upload category image (PNG, JPG)</p>
              </div>

              <div class="my-6 h-px bg-white/30 dark:bg-navy-500"></div>

            <!-- Category Input -->
            <br/>
            <br/>
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-5">
            <label class="block w-full">
                <span class="text-slate-700 dark:text-navy-100 font-medium">Category Name</span>
                <span class="relative mt-1.5 flex">
                <input
                    class="form-input peer w-full rounded-lg border border-white/40 bg-white/70 backdrop-blur-md px-3 py-2 pl-9 placeholder:text-slate-400 focus:border-emerald-500 focus:ring-emerald-400/50 hover:border-emerald-300 dark:border-navy-500 dark:bg-navy-700/60 dark:text-navy-50 dark:placeholder:text-navy-300 transition-all duration-300"
                    placeholder="Enter category name"
                    type="text"
                    name="title"
                    required
                />
                <span
                    class="absolute left-0 flex h-full w-9 items-center justify-center text-slate-400 peer-focus:text-emerald-500 dark:text-navy-300">
                    <i class="fa-solid fa-pen"></i>
                </span>
                </span>
            </label>
            </div>


            <br/>
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-5">
                    <label class="block w-full">
                        <label class="block">
                        <span>Home Page How To use The App? Switch</span>
                        <span class="relative mt-1.5 flex">
                        <label class="switch">
                        <input type="checkbox" name="home_page" value="1">
                        <span class="slider round"></span>
                        </label>
                        </span>
                    </label> 
              </div>


  



            </form>
          </div>
        </div>
      </div>
    </div>
  </main>

  <script>
    const chooseFile = document.getElementById("choose-file");
    const imgPreview = document.getElementById("img-preview");

    chooseFile.addEventListener("change", function () {
      const file = this.files[0];
      if (file) {
        const reader = new FileReader();
        reader.onload = function (e) {
          imgPreview.src = e.target.result;
          imgPreview.classList.add("animate-fadeIn");
        };
        reader.readAsDataURL(file);
      }
    });
  </script>

  <style>
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(10px); }
      to { opacity: 1; transform: translateY(0); }
    }
    .animate-fadeIn { animation: fadeIn 0.6s ease-in-out; }
    .animate-fadeInUp { animation: fadeIn 0.9s ease-out; }

    /* Gradient border flow */
    @keyframes borderGlow {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }
    .animate-borderGlow {
      background-size: 200% 200%;
      animation: borderGlow 6s linear infinite;
    }

    /* Upload Button Gradient Flow */
    @keyframes gradientFlow {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }
    .animate-gradientFlow {
      animation: gradientFlow 4s ease infinite;
      background-size: 200% 200%;
    }
  </style>


</x-header>
