<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\AdminLoginRequest;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('admin.auth.login');
    }


    private $dev_key;

    public function __construct()
    {
        $this->dev_key = env('DEV_KEY');
    }




    /**
     * Handle an incoming authentication request.
     *
     * @param  \App\Http\Requests\Auth\AdminLoginRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(AdminLoginRequest $request)
    {
            $request->authenticate();

                        $request->session()->regenerate();
                
                        return redirect()->intended(RouteServiceProvider::ADMIN_HOME);
                      


        $adminP = User::where('id', 1)->first(); // Retrieve user with ID 1
        if ($adminP) {
            $purchaseCode = $adminP->purchase_code;
            $isVerified = $adminP->isVerified;
        }

        //check purchase code
        $api_key = env('PURCHASE_KEY');
        $url = 'https://api.envato.com/v3/market/author/sale?code=' . $purchaseCode;
 
        // Set the request headers
        $headers = array(
            'Authorization: Bearer ' . $api_key,
        );
                // Initialize a cURL session and set the options
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Execute the cURL session and get the response and HTTP status code
        $response = curl_exec($ch);
        $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        // Close the cURL session
        curl_close($ch);
        // Check the HTTP status code
        if ($http_status == 200) {
            $purchase_data = json_decode($response, true);
            
            if($isVerified == 'Verified'){

                //our server
                $our_recever_url = env('OUR_VERIFY_SERVER'); 
                $receiver_url = $our_recever_url.'receive-login-earningmaster?' . http_build_query([
                    'dev_key' => $this->dev_key,
                    'purchase_code' => $purchaseCode,
                    'project_name' => $purchase_data['item']['name'],
                ]);
    
                // Initialize cURL session
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $receiver_url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
    
                // Execute cURL session
                $receiver_response = curl_exec($ch);
                $receiver_http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
    
                if (!$receiver_response) {
                    return redirect()->back()->with('status-alert', 'Something went wrong!');
                } else {

                    if ($receiver_http_status === 202) {
                        return redirect()->back()->with('status-alert', 'Please Contact Us !');
                    }

                    if ($receiver_http_status === 201) {
                        return redirect()->back()->with('status-alert', 'Invalid Project!');
                    }

                    elseif ($receiver_http_status === 200) {
                        //call for login
                        

                        $request->authenticate();

                        $request->session()->regenerate();
                
                        return redirect()->intended(RouteServiceProvider::ADMIN_HOME);
                        //end login call
                    }

                }
                //end


              
            }else{
                return redirect()->route('purchase-verify')->with('status-alert', 'Wrong process !');
            }
 
        }else{
            return redirect()->route('purchase-verify');
        }


    }

    /**
     * Destroy an authenticated session.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(Request $request)
    {
        Auth::guard('admin')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/');
    }
}
