<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;

class PurchaseVerify extends Controller
{
    //

    private $dev_key;

    public function __construct()
    {
        $this->dev_key = env('DEV_KEY');
    }



    public function get_purchaseverify()
    {
        return view('admin.auth.verify');
    }
    
 


    
    public function req_verifypurchasecode(Request $req)
    {


        //  $api_key = env('PURCHASE_KEY');

    
        $company_name = $req['company_name']; 
        $customer_email = $req['customer_email']; 
        $app_package_id = $req['app_package_id']; 
        $purchase_code = $req['purchase_code'];


        $api_key = env('PURCHASE_KEY');
        $envato_api_url = env('ENVATO_API_URL');
        $project_name = env('PROJECT_NAME'); 
        $our_recever_url = env('OUR_VERIFY_SERVER'); 
        $headers = array(
            'Authorization: Bearer ' . $api_key,
        );

        $baseUrl = url('/');

        $keyReady = $envato_api_url. $req['purchase_code'];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $keyReady);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($http_status == 200) {
            $purchase_data = json_decode($response, true);

      
            $receiver_url = $our_recever_url.'receive-request-earningmaster?' . http_build_query([
                'dev_key' => $this->dev_key,
                'company_name' => $company_name,
                'customer_email' => $customer_email,
                'app_package_id' => $app_package_id,
                'purchase_code' => $purchase_code,
                'admin_url' => $baseUrl ,
                'project_name' => $purchase_data['item']['name']
            ]);

            // Initialize cURL session
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $receiver_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

            // Execute cURL session
            $receiver_response = curl_exec($ch);
            $receiver_http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if (!$receiver_response) {
                return redirect()->back()->with('status-alert', 'Something went wrong!');
            } else {


                if ($receiver_http_status === 401) {
                    return redirect()->back()->with('status-alert', 'Invalid Developer key!');
                }
                
                elseif ($receiver_http_status === 201) {
                    return redirect()->back()->with('status-alert', 'Purchase Code Not For This Project !');
                }

                elseif ($receiver_http_status === 203) {
                    return redirect()->back()->with('status-alert', 'Purchase Code Already Used !');
                }

                elseif ($receiver_http_status === 204) {
                    return redirect()->back()->with('status-alert', 'wrong process! ');
                }
                
                elseif ($receiver_http_status === 200) {

                    $adminP = User::where('id', '1')->first();
                    if ($adminP) {
                        $adminP->isVerified = 'Verified';
                        $adminP->company_name = $company_name;
                        $adminP->verify_email = $customer_email;
                        $adminP->project_name = $project_name;
                        $adminP->purchase_code = $purchase_code;
                        $adminP->save();
 
                        return redirect()->back()->with('status-success', 'Purchase Code Verified successfully !, Please login !');
                    }else{
                        return redirect()->route('admin.404')->with('error', 'deleted faild.');
                    }
        


                    return response()->json([
                        'success' => true,
                        'message' => 'Request successful!',
                        'receiver_response' => $receiver_response,
                    ]);
                }

 
            }
            
                    
           


        }else{
            return redirect()->back()->with('status-alert', 'Envato Purchase Code is Invalid, Please use valid Purchase Code !');
        }




        

        
    }





}
