<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('auser', function (Blueprint $table) {
            $table->id();

            $table->string('name');
            $table->string('email')->unique();
            $table->string('u_id')->default("0");
            $table->string('total_refer')->default("0");
            $table->string('referred_by')->default("0");
            $table->string('status')->default("0");
            $table->string('point')->default("0");
            $table->string('refer_earn')->default("0");
            $table->text('fcmtoken')->nullable();
            $table->text('refer')->nullable();
            $table->text('android_id')->nullable();
            $table->text('country_name')->nullable();
            $table->text('image')->nullable();
            $table->text('signup_type')->nullable();
            $table->string('game_task')->default("0");
 

            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('appuser');
    }
};
