<x-header>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
/* --- General Styling --- */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'Inter', sans-serif;
}

/* Card Containers */
.card {
    background: #fff;
    border-radius: 0.5rem;
    box-shadow: 0 4px 8px rgba(0,0,0,0.05);
    overflow: hidden;
    margin-bottom: 2rem;
    padding: 1.5rem;
}

.dark .card {
    background: #1e293b;
    box-shadow: 0 4px 8px rgba(0,0,0,0.3);
}

/* Headings */
.card h3 {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: #1e293b;
}

.dark .card h3 {
    color: #e2e8f0;
}

/* Input Fields */
.card input, .card select {
    width: 100%;
    padding: 0.75rem 1rem;
    border-radius: 0.375rem;
    border: 1px solid #d1d5db;
    margin-bottom: 1rem;
    font-size: 0.875rem;
    transition: all 0.2s ease;
    background: #fff;
    color: #1e293b;
}

.card input:focus, .card select:focus {
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    outline: none;
}

.dark .card input, .dark .card select {
    background: #1e293b;
    border-color: #475569;
    color: #e2e8f0;
}

/* Buttons */
.card button, .action-btn {
    font-weight: 500;
    border-radius: 0.375rem;
    transition: all 0.2s ease;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
}

.card button {
    padding: 0.75rem 1.5rem;
    color: #fff;
    background: #3b82f6;
}

.card button:hover {
    background: #1d4ed8;
}

/* Table Styling */
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 1rem;
}

th, td {
    padding: 0.75rem 1rem;
    text-align: left;
    border-bottom: 1px solid #e5e7eb;
}

.dark th, .dark td {
    color: #e2e8f0;
    border-bottom: 1px solid #475569;
}

th {
    background: #f3f4f6;
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.dark th {
    background: #334155;
}

/* Row Hover */
tr:hover {
    background: #f9fafb;
}

.dark tr:hover {
    background: #334155;
}

/* Badges */
.badge {
    display: inline-flex;
    align-items: center;
    padding: 0.25rem 0.75rem;
    border-radius: 9999px;
    font-size: 0.75rem;
    font-weight: 500;
    transition: all 0.2s ease;
}

 

/* Action Buttons */
.action-btn {
    padding: 0.4rem 0.8rem;
    font-size: 0.8rem;
    color: #fff;
}

.action-btn.edit { background: #fbbf24; }
.action-btn.edit:hover { background: #f59e0b; }

.action-btn.delete { background: #ef4444; }
.action-btn.delete:hover { background: #dc2626; }

.action-btn.view { background: #3b82f6; }
.action-btn.view:hover { background: #1d4ed8; }

/* Responsive Table */
@media (max-width: 768px) {
    table, thead, tbody, th, td, tr { display: block; }
    th { display: none; }
    td { padding: 0.75rem; border: none; border-bottom: 1px solid #e5e7eb; }
    td::before { 
        content: attr(data-label); 
        font-weight: 600;
        display: inline-block;
        width: 120px;
    }
}
</style>

<main class="main-content w-full px-[var(--margin-x)] pb-8">

    <!-- Breadcrumb -->
    <div class="flex items-center space-x-4 py-5 lg:py-6">
        <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">Admin</h2>
        <div class="hidden h-full py-1 sm:flex">
            <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
        </div>
        <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
            <li class="flex items-center space-x-2">
                <a class="text-primary hover:text-primary-focus dark:text-accent-light" href="{{ route('admin.dashboard') }}">Home</a>
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </li>
            <li>Payment Methods</li>
        </ul>
    </div>

    <!-- Success Message -->
    @if(session('status-success'))
    <div class="alert flex rounded-lg bg-success px-4 py-4 text-white sm:px-5 mb-3 sess_msg">
        {{ session('status-success') }}
    </div>
    @endif

<!-- Add Payment Method Form -->
<div class="card">
    <h3>Add Payment Method</h3>
    <form action="{{ url('/admin/add_payment_methodreq') }}" method="POST" enctype="multipart/form-data" class="space-y-4">
        @csrf

        <!-- Payment Method Name -->
        <input type="text" name="py_title" placeholder="Payment Method Name" required>

        <!-- Logo Upload -->
        <div>
            <label class="block text-sm font-medium text-slate-700 dark:text-navy-100 mb-1">Payment Method Logo</label>
            <div class="flex items-center space-x-3">
                <!-- Preview -->
                <img id="logo-preview" src="https://via.placeholder.com/60x60?text=Logo" alt="Logo Preview" class="w-16 h-16 rounded-md border border-slate-300 dark:border-navy-500 object-cover">

                <!-- File Upload Button -->
                <label class="cursor-pointer bg-slate-100 dark:bg-navy-700 text-slate-700 dark:text-navy-100 px-4 py-2 rounded-md hover:bg-slate-200 dark:hover:bg-navy-600 flex items-center space-x-2">
                    <span>Choose File</span>
                    <input
                        type="file"
                        name="py_logo"
                        id="choose-file"
                        accept="image/*"
                        class="hidden"
                        required
                    />
                </label>
            </div>
            <p class="text-xs text-slate-500 dark:text-navy-400 mt-1">Upload logo image (PNG, JPG, JPEG). Max 2MB.</p>
        </div>

       

        <!-- Currency -->
        <input type="text" name="py_currency" placeholder="Currency (USD, etc.)" required>

        <!-- Type Hints -->
        <input type="text" name="py_inouthint" placeholder="Type Hint 1" required>
        <input type="text" name="py_inputhint2" placeholder="Type Hint 2" required>

        <!-- Submit Button -->
        <button type="submit">Add Payment Method</button>
    </form>
</div>

<!-- Script for Logo Preview -->
<script>
    const chooseFile = document.getElementById("choose-file");
    const logoPreview = document.getElementById("logo-preview");

    chooseFile.addEventListener("change", function(){
        const file = this.files[0];
        if(file){
            const reader = new FileReader();
            reader.onload = function(e){
                logoPreview.setAttribute("src", e.target.result);
            }
            reader.readAsDataURL(file);
        }
    });
</script>

    <!-- Payment Methods Table -->
    <div class="card">
        <h3>Payment Methods List</h3>
        <div class="overflow-x-auto">
            <table>
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Name</th>
                        <th>Logo</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($redeem as $user)
                    <tr>
                        <td data-label="Id">{{$user->id}}</td>
                        <td data-label="Name">{{$user->py_title}}</td>
                           <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                            <div class="avatar flex h-10 w-10">
                              <img class="mask is-squircle" alt="avatar" src="/images/upload/payment/{{$user->py_logo}}">
                            </div>
                          </td> 
                        <td data-label="Amount">
                            <a href="{{url('/admin/view_amount/'.$user->id)}}" class="action-btn view">View Payment</a>
                        </td>
                        <td data-label="Status">
                            @if($user->status==0)
                                <span class="badge bg-success/10">Enable</span>
                            @else
                                <span class="badge bg-error/10">Disabled</span>
                            @endif
                        </td>
                        <td data-label="Action">
                            <div class="flex space-x-2">
                                <a href="{{url('/admin/edit_payment/'.$user->id)}}" class="action-btn edit">Edit</a>
                                <a href="{{url('/admin/delete_payment/'.$user->id)}}" class="action-btn delete">Delete</a>
                                
                            </div>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>

        <div class="flex justify-end mt-4">
            {{$redeem->links()}}
        </div>
    </div>

</main>
</x-header>
