<?php

use App\Http\Controllers\Admin\HomeController;
use App\Http\Controllers\PurchaseVerify;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('purchase-verify', [PurchaseVerify::class, 'get_purchaseverify'])->name('purchase-verify');
Route::post('/purchase-verify', [PurchaseVerify::class, 'req_verifypurchasecode'])->name('verify-purchasecode');


Route::get('/refer/{refer_id}','UserController@refer')->name('refer');
Route::get('/data-delete','Admin\HomeController@account_deletion')->name('account_deletion');
Route::get('/', 'Admin\HomeController@login')->middleware('guest:admin');

//pages
Route::get('/page/{slug}', 'Admin\HomeController@web_pages')->name('web_pages');
Route::namespace('Admin')->prefix('admin')->name('admin.')->group(function(){
Route::namespace('Auth')->middleware('guest:admin')->group(function(){
Route::post('login','AuthenticatedSessionController@store')->name('adminlogin');
});

Route::get('/', 'HomeController@main')->middleware('guest:admin');
Route::middleware('admin')->group(function(){

//new all code


//wallpaper category
Route::get('add_wallpaper_category','HomeController@add_wallpaper_category')->name('add_wallpaper_category')->middleware('bs');
Route::post('add_wallpaper_category','HomeController@add_wallcatred')->name('add_wallcatred')->middleware('bs');
Route::get('wallpapers_category','HomeController@wallpapers_category')->name('wallpapers_category')->middleware('bs');
Route::get('delete_wallcat/{id}','HomeController@delete_wallcat')->name('delete_wallcat')->middleware('bs');

//wallpaper
Route::get('add_wallpaper','HomeController@add_wallpaper')->name('add_wallpaper')->middleware('bs');
Route::post('add_wallpaper','HomeController@add_wallpaperreq')->name('add_wallpaperreq')->middleware('bs');
Route::get('wallpapers','HomeController@wallpapers')->name('wallpapers')->middleware('bs');
Route::get('delete_wallpaper/{id}','HomeController@delete_wallpaper')->name('delete_wallpaper')->middleware('bs');
Route::post('wallpaper_config','HomeController@wallpaper_configreq')->name('wallpaper_configreq')->middleware('bs');
Route::get('view_amount/{id}','HomeController@view_amount')->name('view_amount')->middleware('bs');
Route::post('add_paymentamount/{id}','HomeController@add_paymentamount')->name('add_paymentamount')->middleware('bs');
Route::get('delete_amount/{id}','HomeController@delete_amount')->name('delete_amount')->middleware('bs');
Route::get('delete_payment/{id}','HomeController@delete_payment')->name('delete_payment')->middleware('bs');


Route::get('game_settings','HomeController@game_settings')->name('game_settings')->middleware('bs');
Route::post('game_settingupdate','HomeController@game_settingupdate')->name('game_settingupdate')->middleware('bs');


Route::get('ai_captionsettting','HomeController@ai_captionsettting')->name('ai_captionsettting')->middleware('bs');
Route::get('daily_reward','HomeController@daily_reward')->name('daily_reward')->middleware('bs');
Route::post('daily_rewardreq','HomeController@daily_rewardreq')->name('daily_rewardreq')->middleware('bs');
Route::get('survey_offersettings','HomeController@survey_offersettings')->name('survey_offersettings')->middleware('bs');
Route::post('update_surveyandofffer','HomeController@update_surveyandofffer')->name('update_surveyandofffer')->middleware('bs');
Route::get('add_quickbonus','HomeController@add_quickbonus')->name('add_quickbonus')->middleware('bs');
Route::post('/add_quickbonus','HomeController@add_quickbonusreq')->name('add_quickbonusreq')->middleware('bs');
Route::get('quick_bonus','HomeController@quick_bonus')->name('quick_bonus')->middleware('bs');
Route::post('/quick_bonusup','HomeController@quick_bonusup')->name('quick_bonusup')->middleware('bs');
Route::post('/gametask_update','HomeController@gametask_update')->name('gametask_update')->middleware('bs');
Route::get('gametask','HomeController@gametask')->name('gametask')->middleware('bs');
Route::get('add_game','HomeController@add_game')->name('add_game')->middleware('bs');
Route::post('/add_game','HomeController@add_gamereq')->name('add_gamereq')->middleware('bs');
Route::get('game_list','HomeController@game_list')->name('game_list')->middleware('bs');
Route::get('delete_game/{id}','HomeController@delete_game')->name('delete_game')->middleware('bs');
Route::get('play_quiz','HomeController@play_quiz')->name('play_quiz')->middleware('bs');
Route::post('updateplay_quiz','HomeController@updateplay_quiz')->name('updateplay_quiz')->middleware('bs');
Route::get('reward_vault','HomeController@reward_vault')->name('reward_vault')->middleware('bs');
Route::post('update_reward_vault','HomeController@update_reward_vault')->name('update_reward_vault')->middleware('bs');
Route::get('add_article','HomeController@add_article')->name('add_article')->middleware('bs');
Route::post('/add_article','HomeController@add_articlereq')->name('add_articlereq')->middleware('bs');
Route::get('article_list','HomeController@article_list')->name('article_list')->middleware('bs');
Route::get('delete_ar/{id}','HomeController@delete_ar')->name('delete_ar')->middleware('bs');
Route::post('updatearticle_config','HomeController@updatearticle_config')->name('updatearticle_config')->middleware('bs');
Route::get('article_config','HomeController@article_config')->name('article_config')->middleware('bs');
Route::get('add_payment_method','HomeController@add_payment_method')->name('add_payment_method')->middleware('bs');
Route::post('/add_payment_methodreq','HomeController@add_payment_methodreq')->name('add_payment_methodreq')->middleware('bs');
Route::get('terms_edit','HomeController@terms_edit')->name('terms_edit')->middleware('bs');
Route::put('/terms_edit','HomeController@upterms_edit')->name('upterms_edit')->middleware('bs');
Route::get('app_config','HomeController@app_config')->name('app_config')->middleware('bs');
Route::get('refer_config','HomeController@refer_config')->name('refer_config')->middleware('bs');
Route::post('/referconfigupdate','HomeController@referconfigupdate')->name('referconfigupdate')->middleware('bs');
Route::post('/appconfig_update','HomeController@appconfig_update')->name('appconfig_update')->middleware('bs');
Route::get('/edit/{id}','HomeController@edit_user')->name('useredit')->middleware('bs');
Route::put('/edit/{id}','HomeController@update_user');
Route::get('wallpapers_list','HomeController@wallpapers_list')->name('wallpapers_list')->middleware('bs');
Route::get('delete_wallpaper/{id}','HomeController@delete_wallpaper')->name('delete_wallpaper')->middleware('bs');
Route::get('quick_blist','HomeController@quick_blist')->name('quick_blist')->middleware('bs');
Route::get('delete_qbonus/{id}','HomeController@delete_qbonus')->name('delete_qbonus')->middleware('bs');
Route::get('payment_methodlist','HomeController@payment_methodlist')->name('payment_methodlist')->middleware('bs');
Route::get('payment_request','HomeController@payment_request')->name('payment_request')->middleware('bs');
Route::get('paymentrequest-status/{id}/{id2}','HomeController@paymentrequest_status')->name('paymentrequest_status');
Route::get('view_paymentrequest/{id}','HomeController@view_paymentrequest')->name('view_paymentrequest');
Route::get('payment_request','HomeController@payment_request')->name('payment_request')->middleware('bs');
Route::get('payment_method','HomeController@payment_method')->name('payment_method')->middleware('bs');
Route::get('view_payment/{id}','HomeController@view_payment')->name('view_payment');
Route::put('/view_payment/{id}','HomeController@update_payment');
Route::get('add_banner','HomeController@add_banner')->name('add_banner')->middleware('bs');
Route::get('banner_list','HomeController@banner_list')->name('banner_list')->middleware('bs');
Route::post('add_banner','HomeController@add_bannerreq')->name('add_bannerreq')->middleware('bs');
Route::get('delete_banner/{id}','HomeController@delete_banner')->name('delete_banner')->middleware('bs');
Route::get('ad_unit','HomeController@ad_unit')->name('ad_unit')->middleware('bs');
Route::post('update_adunit','HomeController@update_adunit')->name('update_adunit')->middleware('bs');



Route::get('dashboard','HomeController@index')->name('dashboard')->middleware('bs');
Route::get('users','HomeController@users')->name('users')->middleware('bs');
Route::get('user/delete/{id}','HomeController@admin_del_user')->name('del_user');
Route::get('/tracking/{id}','HomeController@tracking_user')->name('tracking_user')->middleware('bs');
Route::get('user-status/{id}/{id2}','HomeController@app_status_user')->name('app_status_user');
Route::get('/tracking','HomeController@tracking')->name('tracking')->middleware('bs');
Route::get('plan','HomeController@plan')->name('plan')->middleware('bs');
Route::get('plan-status/{id}/{id2}','HomeController@plan_status')->name('plan_status');
Route::get('payment_plan','HomeController@payment_plan')->name('payment_plan');
Route::get('planpm-status/{id}/{id2}','HomeController@planpm_status')->name('planpm_status');
Route::get('/edit-plan/{id}','HomeController@edit_plan')->name('edit_plan')->middleware('bs');
Route::get('plan/del_plan/{id}', 'HomeController@admin_del_plan')->name('del_plan');
Route::put('/edit-plan/{id}','HomeController@update_plan');
Route::get('add_plan','HomeController@add_plan')->name('add_plan')->middleware('bs');
Route::post('/add_plan','HomeController@add_planreq')->name('add_planreq')->middleware('bs');
Route::get('plan_request','HomeController@plan_request')->name('plan_request')->middleware('bs');
Route::get('/view-planrequest/{id}','HomeController@view_planrequest')->name('view_planrequest')->middleware('bs');
Route::get('user_profile','HomeController@user_profile')->name('user_profile')->middleware('bs');
Route::get('planre_status_ap/{id}/{id2}/{duration}/{amount}/{deposit_amount}/{plan_name}/{u_id}','HomeController@planre_status_approve')->name('planre_status_approve');
Route::get('planre-status/{id}/{id2}','HomeController@planrestatus')->name('planrestatus');
Route::get('add_payment','HomeController@add_payment')->name('add_payment')->middleware('bs');
Route::post('/add_payment','HomeController@add_paymentrq')->name('add_paymentrq')->middleware('bs');
Route::get('payment-status/{id}/{id2}','HomeController@payment_status')->name('payment_status');
Route::get('payment/del_payemtm/{id}', 'HomeController@admin_del_payemtm')->name('del_payemtm');
Route::get('send_notification','HomeController@send_notification')->name('send_notification')->middleware('bs');
Route::get('all_notification','HomeController@all_notification')->name('all_notification')->middleware('bs');
Route::get('notification/del_notification/{id}', 'HomeController@admin_del_notification')->name('del_notification');
Route::get('notification-status/{id}/{id2}','HomeController@notification_status')->name('notification_status');
Route::post('/send_notification','HomeController@push_notification')->name('push_notification');
Route::get('support','HomeController@support')->name('support')->middleware('bs');
Route::get('app_setting','HomeController@app_setting')->name('app_setting')->middleware('bs');
Route::post('/app_setting','HomeController@upapp_setting')->name('upapp_setting')->middleware('bs');
Route::get('admin_settings','HomeController@admin_settings')->name('admin_settings')->middleware('bs');
Route::put('/admin_settings','HomeController@updateadmin_settings')->name('updateadmin_settings')->middleware('bs');
Route::get('fraud_prevention','HomeController@fraud_prevention')->name('fraud_prevention')->middleware('bs');
Route::post('/fraud_prevention','HomeController@upfraud_prevention')->name('upfraud_prevention')->middleware('bs');
Route::get('all_page','HomeController@all_page')->name('all_page')->middleware('bs');
Route::get('terms_conditions','HomeController@terms_conditions')->name('terms_conditions')->middleware('bs');
Route::get('privacy_edit','HomeController@privacy_edit')->name('privacy_edit')->middleware('bs');
Route::put('/privacy_edit','HomeController@upprivacy_edit')->name('upprivacy_edit')->middleware('bs');
Route::get('privacy_policy','HomeController@privacy_policy')->name('privacy_policy')->middleware('bs');




});
Route::get('login','HomeController@login')->name('login');
Route::post('logout','Auth\AuthenticatedSessionController@destroy')->name('logout');
});


 

Route::get('adminadd', [HomeController::class, 'adminadd'])->name('adminadd');






