<?php if (isset($component)) { $__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Header::class, []); ?>
<?php $component->withName('header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
    <!-- Add required CSS for animations -->
    <style>
        @keyframes  fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes  pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        
        @keyframes  countUp {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        .animate-fadeIn {
            animation: fadeIn 0.6s ease-out forwards;
        }
        
        .animate-pulse {
            animation: pulse 2s infinite;
        }
        
        .animate-countUp {
            animation: countUp 1s ease-out forwards;
        }
        
        .stat-card {
            transition: all 0.3s ease;
            overflow: hidden;
            border-radius: 0.75rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        
        .stat-icon {
            transition: all 0.3s ease;
        }
        
        .stat-card:hover .stat-icon {
            transform: scale(1.2);
        }
        
        .progress-bar {
            height: 6px;
            border-radius: 3px;
            background: #e2e8f0;
            margin-top: 8px;
            overflow: hidden;
        }
        
        .progress-value {
            height: 100%;
            border-radius: 3px;
            transition: width 1s ease-in-out;
        }
        
        .chart-container {
            height: 300px;
            width: 100%;
        }
        
        .dashboard-header {
            background: linear-gradient(135deg, #4f46e5 0%, #7e3af2 100%);
            border-radius: 0.75rem;
            margin-bottom: 1.5rem;
            padding: 1.5rem;
            color: white;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
    </style>

    <!-- Main Content Wrapper -->
    <main  class="main-content w-full px-[var(--margin-x)] pb-8">
        <!-- Dashboard Header -->
        <div style="margin-top: 40px;" class="dashboard-header animate-fadeIn" style="animation-delay: 0.1s">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-2xl font-bold lg:text-3xl">Admin Dashboard</h1>
                    <p class="mt-1 text-white/80">Welcome back, Admin! Here's what's happening with your rewards app today.</p>
                </div>
                <div class="hidden md:block">
                    <div class="flex items-center space-x-2">
                        <span class="px-3 py-1 bg-white/20 rounded-full text-sm">
                            <i class="fa fa-calendar-alt mr-1"></i> <?php echo e(date('d M, Y')); ?>

                        </span>
                        <span class="px-3 py-1 bg-white/20 rounded-full text-sm">
                            <i class="fa fa-clock mr-1"></i> <span id="live-time"><?php echo e(date('h:i A')); ?></span>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Alert Messages -->
        <?php if(session('status-alert')): ?>
            <div class="alert flex rounded-lg bg-error px-4 py-4 text-white sm:px-5 sess_msg mb-3 animate-fadeIn">
                <i class="fa fa-exclamation-circle mr-2 text-xl"></i>
                <?php echo e(session('status-alert')); ?>

            </div>
        <?php elseif(session('status-success')): ?>
            <div class="alert flex rounded-lg bg-success px-4 py-4 text-white sm:px-5 mb-3 sess_msg mb-3 animate-fadeIn">
                <i class="fa fa-check-circle mr-2 text-xl"></i>
                <?php echo e(session('status-success')); ?>

            </div>
        <?php endif; ?>

        <!-- Stats Overview -->
        <div class="grid grid-cols-12 gap-4 sm:gap-5 lg:gap-6">
            <!-- Stats Cards Section -->
            <div class="col-span-12 lg:col-span-8">
                <div class="mb-6">
                    <h2 class="text-lg font-medium text-slate-800 dark:text-navy-50 mb-3">
                        <i class="fa fa-chart-line mr-2"></i>Key Metrics
                    </h2>
                    
                    <!-- Stats Cards Grid -->
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-5 lg:gap-6">
                        <!-- Today's Coins -->
                        <div class="stat-card bg-white dark:bg-navy-700 p-5 animate-fadeIn" style="animation-delay: 0.2s">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-sm font-medium text-slate-400 dark:text-navy-300">
                                        Today's Coins
                                    </p>
                                    <h3 class="mt-1 text-2xl font-bold text-slate-700 dark:text-navy-100 animate-countUp">
                                        <?php echo e($today_earn); ?>

                                    </h3>
                                </div>
                                <div class="stat-icon p-2 bg-amber-100 dark:bg-amber-900/20 rounded-full">
                                    <i class="fa fa-coins text-amber-500 text-xl"></i>
                                </div>
                            </div>
                            <div class="mt-3">
                                <div class="flex items-center text-xs">
                                    <span class="text-emerald-500 flex items-center">
                                        <i class="fa fa-arrow-up mr-1"></i> 12%
                                    </span>
                                    <span class="ml-1.5 text-slate-400 dark:text-navy-300">from yesterday</span>
                                </div>
                                <div class="progress-bar mt-2">
                                    <div class="progress-value bg-amber-500" style="width: 65%"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Total Points -->
                        <div class="stat-card bg-white dark:bg-navy-700 p-5 animate-fadeIn" style="animation-delay: 0.3s">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-sm font-medium text-slate-400 dark:text-navy-300">
                                        Total Points
                                    </p>
                                    <h3 class="mt-1 text-2xl font-bold text-slate-700 dark:text-navy-100 animate-countUp">
                                        <?php echo e($total_point); ?>

                                    </h3>
                                </div>
                                <div class="stat-icon p-2 bg-emerald-100 dark:bg-emerald-900/20 rounded-full">
                                    <i class="fa fa-star text-emerald-500 text-xl"></i>
                                </div>
                            </div>
                            <div class="mt-3">
                                <div class="flex items-center text-xs">
                                    <span class="text-emerald-500 flex items-center">
                                        <i class="fa fa-arrow-up mr-1"></i> 8.2%
                                    </span>
                                    <span class="ml-1.5 text-slate-400 dark:text-navy-300">from last week</span>
                                </div>
                                <div class="progress-bar mt-2">
                                    <div class="progress-value bg-emerald-500" style="width: 78%"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Total Users -->
                        <div class="stat-card bg-white dark:bg-navy-700 p-5 animate-fadeIn" style="animation-delay: 0.4s">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-sm font-medium text-slate-400 dark:text-navy-300">
                                        Total Users
                                    </p>
                                    <h3 class="mt-1 text-2xl font-bold text-slate-700 dark:text-navy-100 animate-countUp">
                                        <?php echo e($total_user); ?>

                                    </h3>
                                </div>
                                <div class="stat-icon p-2 bg-blue-100 dark:bg-blue-900/20 rounded-full">
                                    <i class="fa fa-users text-blue-500 text-xl"></i>
                                </div>
                            </div>
                            <div class="mt-3">
                                <div class="flex items-center text-xs">
                                    <span class="text-emerald-500 flex items-center">
                                        <i class="fa fa-arrow-up mr-1"></i> 5.3%
                                    </span>
                                    <span class="ml-1.5 text-slate-400 dark:text-navy-300">from last month</span>
                                </div>
                                <div class="progress-bar mt-2">
                                    <div class="progress-value bg-blue-500" style="width: 82%"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Today's Users -->
                        <div class="stat-card bg-white dark:bg-navy-700 p-5 animate-fadeIn" style="animation-delay: 0.5s">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-sm font-medium text-slate-400 dark:text-navy-300">
                                        Today's Users
                                    </p>
                                    <h3 class="mt-1 text-2xl font-bold text-slate-700 dark:text-navy-100 animate-countUp">
                                        <?php echo e($today_user); ?>

                                    </h3>
                                </div>
                                <div class="stat-icon p-2 bg-indigo-100 dark:bg-indigo-900/20 rounded-full">
                                    <i class="fa fa-user-plus text-indigo-500 text-xl"></i>
                                </div>
                            </div>
                            <div class="mt-3">
                                <div class="flex items-center text-xs">
                                    <span class="text-emerald-500 flex items-center">
                                        <i class="fa fa-arrow-up mr-1"></i> 3.7%
                                    </span>
                                    <span class="ml-1.5 text-slate-400 dark:text-navy-300">from yesterday</span>
                                </div>
                                <div class="progress-bar mt-2">
                                    <div class="progress-value bg-indigo-500" style="width: 45%"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Today's Redeem -->
                        <div class="stat-card bg-white dark:bg-navy-700 p-5 animate-fadeIn" style="animation-delay: 0.6s">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-sm font-medium text-slate-400 dark:text-navy-300">
                                        Today's Redeem
                                    </p>
                                    <h3 class="mt-1 text-2xl font-bold text-slate-700 dark:text-navy-100 animate-countUp">
                                        <?php echo e($tody_redeem); ?>

                                    </h3>
                                </div>
                                <div class="stat-icon p-2 bg-purple-100 dark:bg-purple-900/20 rounded-full">
                                    <i class="fa fa-exchange-alt text-purple-500 text-xl"></i>
                                </div>
                            </div>
                            <div class="mt-3">
                                <div class="flex items-center text-xs">
                                    <span class="text-rose-500 flex items-center">
                                        <i class="fa fa-arrow-down mr-1"></i> 2.1%
                                    </span>
                                    <span class="ml-1.5 text-slate-400 dark:text-navy-300">from yesterday</span>
                                </div>
                                <div class="progress-bar mt-2">
                                    <div class="progress-value bg-purple-500" style="width: 38%"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Total Redeem -->
                        <div class="stat-card bg-white dark:bg-navy-700 p-5 animate-fadeIn" style="animation-delay: 0.7s">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-sm font-medium text-slate-400 dark:text-navy-300">
                                        Total Redeem
                                    </p>
                                    <h3 class="mt-1 text-2xl font-bold text-slate-700 dark:text-navy-100 animate-countUp">
                                        <?php echo e($total_redem); ?>

                                    </h3>
                                </div>
                                <div class="stat-icon p-2 bg-amber-100 dark:bg-amber-900/20 rounded-full">
                                    <i class="fa fa-gift text-amber-500 text-xl"></i>
                                </div>
                            </div>
                            <div class="mt-3">
                                <div class="flex items-center text-xs">
                                    <span class="text-emerald-500 flex items-center">
                                        <i class="fa fa-arrow-up mr-1"></i> 7.2%
                                    </span>
                                    <span class="ml-1.5 text-slate-400 dark:text-navy-300">from last month</span>
                                </div>
                                <div class="progress-bar mt-2">
                                    <div class="progress-value bg-amber-500" style="width: 72%"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Pending Redeem -->
                        <div class="stat-card bg-white dark:bg-navy-700 p-5 animate-fadeIn" style="animation-delay: 0.8s">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-sm font-medium text-slate-400 dark:text-navy-300">
                                        Pending Redeem
                                    </p>
                                    <h3 class="mt-1 text-2xl font-bold text-slate-700 dark:text-navy-100 animate-countUp">
                                        <?php echo e($pending_redeem ?? 0); ?>

                                    </h3>
                                </div>
                                <div class="stat-icon p-2 bg-orange-100 dark:bg-orange-900/20 rounded-full">
                                    <i class="fa fa-clock text-orange-500 text-xl"></i>
                                </div>
                            </div>
                            <div class="mt-3">
                                <div class="flex items-center text-xs">
                                    <span class="text-rose-500 flex items-center">
                                        <i class="fa fa-arrow-up mr-1"></i> 4.3%
                                    </span>
                                    <span class="ml-1.5 text-slate-400 dark:text-navy-300">from yesterday</span>
                                </div>
                                <div class="progress-bar mt-2">
                                    <div class="progress-value bg-orange-500" style="width: 28%"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Paid Redeem -->
                        <div class="stat-card bg-white dark:bg-navy-700 p-5 animate-fadeIn" style="animation-delay: 0.9s">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-sm font-medium text-slate-400 dark:text-navy-300">
                                        Paid Redeem
                                    </p>
                                    <h3 class="mt-1 text-2xl font-bold text-slate-700 dark:text-navy-100 animate-countUp">
                                        <?php echo e($paid_redeem ?? 0); ?>

                                    </h3>
                                </div>
                                <div class="stat-icon p-2 bg-green-100 dark:bg-green-900/20 rounded-full">
                                    <i class="fa fa-check-circle text-green-500 text-xl"></i>
                                </div>
                            </div>
                            <div class="mt-3">
                                <div class="flex items-center text-xs">
                                    <span class="text-emerald-500 flex items-center">
                                        <i class="fa fa-arrow-up mr-1"></i> 6.8%
                                    </span>
                                    <span class="ml-1.5 text-slate-400 dark:text-navy-300">from last week</span>
                                </div>
                                <div class="progress-bar mt-2">
                                    <div class="progress-value bg-green-500" style="width: 65%"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Total Tasks Done -->
                        <div class="stat-card bg-white dark:bg-navy-700 p-5 animate-fadeIn" style="animation-delay: 1s">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-sm font-medium text-slate-400 dark:text-navy-300">
                                        Total Tasks Done
                                    </p>
                                    <h3 class="mt-1 text-2xl font-bold text-slate-700 dark:text-navy-100 animate-countUp">
                                        <?php echo e($total_tasks_done ?? 0); ?>

                                    </h3>
                                </div>
                                <div class="stat-icon p-2 bg-blue-100 dark:bg-blue-900/20 rounded-full">
                                    <i class="fa fa-tasks text-blue-500 text-xl"></i>
                                </div>
                            </div>
                            <div class="mt-3">
                                <div class="flex items-center text-xs">
                                    <span class="text-emerald-500 flex items-center">
                                        <i class="fa fa-arrow-up mr-1"></i> 9.2%
                                    </span>
                                    <span class="ml-1.5 text-slate-400 dark:text-navy-300">from last month</span>
                                </div>
                                <div class="progress-bar mt-2">
                                    <div class="progress-value bg-blue-500" style="width: 88%"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Charts Section -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-5 lg:gap-6 mt-4 animate-fadeIn" style="animation-delay: 1.1s">
                    <!-- User Growth Chart -->
                    <div class="stat-card bg-white dark:bg-navy-700 p-5">
                        <div class="flex justify-between items-center mb-3">
                            <h3 class="font-medium text-slate-700 dark:text-navy-100">User Growth</h3>
                            <div class="flex space-x-2">
                                <button class="text-xs px-2 py-1 rounded bg-slate-100 dark:bg-navy-800">Week</button>
                                <button class="text-xs px-2 py-1 rounded bg-primary text-white">Month</button>
                                <button class="text-xs px-2 py-1 rounded bg-slate-100 dark:bg-navy-800">Year</button>
                            </div>
                        </div>
                        <div class="chart-container" id="userGrowthChart">
                            <!-- Chart will be rendered here by JavaScript -->
                            <div class="flex items-center justify-center h-full text-slate-400">
                                <p>Loading chart data...</p>
                            </div>
                        </div>
                    </div>

                    <!-- Rewards Distribution Chart -->
                    <div class="stat-card bg-white dark:bg-navy-700 p-5">
                        <div class="flex justify-between items-center mb-3">
                            <h3 class="font-medium text-slate-700 dark:text-navy-100">Rewards Distribution</h3>
                            <div class="flex space-x-2">
                                <button class="text-xs px-2 py-1 rounded bg-slate-100 dark:bg-navy-800">Week</button>
                                <button class="text-xs px-2 py-1 rounded bg-primary text-white">Month</button>
                                <button class="text-xs px-2 py-1 rounded bg-slate-100 dark:bg-navy-800">Year</button>
                            </div>
                        </div>
                        <div class="chart-container" id="rewardsDistributionChart">
                            <!-- Chart will be rendered here by JavaScript -->
                            <div class="flex items-center justify-center h-full text-slate-400">
                                <p>Loading chart data...</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Sidebar -->
            <div class="col-span-12 lg:col-span-4 space-y-4 sm:space-y-5 lg:space-y-6">
                <!-- Recent Activity -->
                <div class="stat-card bg-white dark:bg-navy-700 p-5 animate-fadeIn" style="animation-delay: 1.2s">
                    <h3 class="font-medium text-slate-700 dark:text-navy-100 mb-4">Recent Activity</h3>
                    <div class="space-y-4">
                        <div class="flex items-start">
                            <div class="h-10 w-10 rounded-full bg-primary/10 flex items-center justify-center text-primary">
                                <i class="fa fa-user-plus"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-slate-700 dark:text-navy-100">New User Registered</p>
                                <p class="text-xs text-slate-400">John Doe just joined the platform</p>
                                <p class="text-xs text-slate-400 mt-1">2 minutes ago</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="h-10 w-10 rounded-full bg-success/10 flex items-center justify-center text-success">
                                <i class="fa fa-coins"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-slate-700 dark:text-navy-100">Points Earned</p>
                                <p class="text-xs text-slate-400">Sarah earned 250 points from tasks</p>
                                <p class="text-xs text-slate-400 mt-1">15 minutes ago</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="h-10 w-10 rounded-full bg-warning/10 flex items-center justify-center text-warning">
                                <i class="fa fa-gift"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-slate-700 dark:text-navy-100">Reward Redeemed</p>
                                <p class="text-xs text-slate-400">Mike redeemed $10 Amazon Gift Card</p>
                                <p class="text-xs text-slate-400 mt-1">1 hour ago</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="h-10 w-10 rounded-full bg-info/10 flex items-center justify-center text-info">
                                <i class="fa fa-tasks"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-slate-700 dark:text-navy-100">New Task Added</p>
                                <p class="text-xs text-slate-400">Admin added "Watch Video" task</p>
                                <p class="text-xs text-slate-400 mt-1">3 hours ago</p>
                            </div>
                        </div>
                    </div>
                    <button class="w-full mt-4 py-2 text-xs font-medium text-primary bg-primary/10 rounded-lg hover:bg-primary/20 transition-colors">
                        View All Activity
                    </button>
                </div>

                <!-- Quick Actions -->
                <div class="stat-card bg-white dark:bg-navy-700 p-5 animate-fadeIn" style="animation-delay: 1.3s">
                    <h3 class="font-medium text-slate-700 dark:text-navy-100 mb-4">Quick Actions</h3>
                    <div class="grid grid-cols-2 gap-3">
                        <a
                         href="<?php echo e(route('admin.users')); ?>"
                          class="p-3 bg-primary/10 rounded-lg flex flex-col items-center justify-center hover:bg-primary/20 transition-colors">
                            <i class="fa fa-user-plus text-primary text-xl mb-2"></i>
                            <span class="text-xs font-medium text-slate-700 dark:text-navy-100">All User</span>
    </a>
                        <a 
                        href="<?php echo e(route('admin.tracking')); ?>"
                        class="p-3 bg-success/10 rounded-lg flex flex-col items-center justify-center hover:bg-success/20 transition-colors">
                            <i class="fa fa-tasks text-success text-xl mb-2"></i>
                            <span class="text-xs font-medium text-slate-700 dark:text-navy-100">New Task</span>
    </a>
   <!--
                        <button class="p-3 bg-warning/10 rounded-lg flex flex-col items-center justify-center hover:bg-warning/20 transition-colors">
                            <i class="fa fa-gift text-warning text-xl mb-2"></i>
                            <span class="text-xs font-medium text-slate-700 dark:text-navy-100">Add Reward</span>
                        </button>
                        <button class="p-3 bg-info/10 rounded-lg flex flex-col items-center justify-center hover:bg-info/20 transition-colors">
                            <i class="fa fa-chart-bar text-info text-xl mb-2"></i>
                            <span class="text-xs font-medium text-slate-700 dark:text-navy-100">Reports</span>
                        </button>
                        -->
                    </div>
                </div>

                 <!-- Top Performers -->
               <div class="stat-card bg-white dark:bg-navy-700 p-5 animate-fadeIn" style="animation-delay: 1.4s">
    <h3 class="font-medium text-slate-700 dark:text-navy-100 mb-4">Top Performers</h3>

    <div class="space-y-4">
        <?php $__currentLoopData = $top_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="h-10 w-10 rounded-full bg-slate-200 flex items-center justify-center overflow-hidden">
                        <?php if(!empty($user->image)): ?>
                            <img src="<?php echo e($user->image); ?>" alt="<?php echo e($user->name); ?>" class="h-10 w-10 object-cover rounded-full">
                        <?php else: ?>
                            <i class="fa fa-user text-slate-500"></i>
                        <?php endif; ?>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-slate-700 dark:text-navy-100"><?php echo e($user->name); ?></p>
                        <p class="text-xs text-slate-400"><?php echo e(number_format($user->point)); ?> points</p>
                    </div>
                </div>
                <div class="bg-primary/10 text-primary text-xs font-medium px-2 py-1 rounded-full">
                    #<?php echo e($index + 1); ?>

                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <button class="w-full mt-4 py-2 text-xs font-medium text-primary bg-primary/10 rounded-lg hover:bg-primary/20 transition-colors">
        View All Users
    </button>
</div>

            </div>
        </div>
    </main>

    <!-- JavaScript for animations and charts -->
    <script>
        // Live time update
        function updateTime() {
            const timeElement = document.getElementById('live-time');
            if (timeElement) {
                const now = new Date();
                const hours = now.getHours() % 12 || 12;
                const minutes = now.getMinutes().toString().padStart(2, '0');
                const ampm = now.getHours() >= 12 ? 'PM' : 'AM';
                timeElement.textContent = `${hours}:${minutes} ${ampm}`;
            }
        }
        
        // Update time every minute
        setInterval(updateTime, 60000);
        updateTime();
        
        // Add animation to session messages
        document.addEventListener('DOMContentLoaded', function() {
            const sessionMessages = document.querySelectorAll('.sess_msg');
            sessionMessages.forEach(msg => {
                setTimeout(() => {
                    msg.classList.add('animate-fadeIn');
                }, 300);
                
                // Auto hide after 5 seconds
                setTimeout(() => {
                    msg.style.opacity = '0';
                    msg.style.transition = 'opacity 0.5s ease-out';
                }, 5000);
            });
        });
        
        // Note: In a real implementation, you would include Chart.js or another charting library
        // and initialize the charts with actual data from your backend
        document.addEventListener('DOMContentLoaded', function() {
            // Placeholder for chart initialization
            console.log('Charts would be initialized here with actual data');
            
            // For demonstration purposes, we'll just hide the loading messages
            setTimeout(() => {
                const chartContainers = document.querySelectorAll('.chart-container');
                chartContainers.forEach(container => {
                    container.innerHTML = '<div class="flex items-center justify-center h-full text-slate-400"><p>Chart would render here with actual data</p></div>';
                });
            }, 1000);
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3)): ?>
<?php $component = $__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3; ?>
<?php unset($__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3); ?>
<?php endif; ?>
<?php /**PATH C:\Users\Md Burhan Uddin\Desktop\Wallpaper Project\api\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>